#!/bin/bash

# ========================================
# 集群 hosts 添加脚本 (Linux / macOS)
# ========================================
# 中文输出
echo "此脚本用于向 hosts 添加集群地址，需要使用 sudo 权限。"
echo

# 检查是否有 sudo 权限
if [[ $EUID -ne 0 ]]; then
   echo "请使用 sudo 执行此脚本！"
   exit 1
fi

HOSTS_FILE="/etc/hosts"
BACKUP_FILE="/etc/hosts.bak.$(date +%Y%m%d%H%M%S)"

# ==============================
# 定义 IP 和主机名（请替换为真实值）
# ==============================
IP1="202.38.252.202"; HOST1="login01"
IP2="202.38.252.203"; HOST2="login02"
IP3="202.38.252.204"; HOST3="login03"
IP4="202.38.252.205"; HOST4="login04"
IP5="202.38.252.210"; HOST5="admin"
IP6="202.38.252.211"; HOST6="login1"

# ==============================
# 备份 hosts
# ==============================
echo "正在备份当前 hosts 文件到 $BACKUP_FILE ..."
cp $HOSTS_FILE $BACKUP_FILE
echo "备份完成。"
echo

# ==============================
# 添加 hosts
# ==============================
add_host() {
    local IP="$1"
    local NAME="$2"

    # 避免重复添加
    if grep -qE "^[[:space:]]*$IP[[:space:]]+$NAME" "$HOSTS_FILE"; then
        echo "$NAME 已存在，跳过添加。"
    else
        echo "$IP $NAME" >> "$HOSTS_FILE"
        echo "已添加：$NAME -> $IP"
    fi
}

echo "正在添加集群主机映射..."
add_host $IP1 $HOST1
add_host $IP2 $HOST2
add_host $IP3 $HOST3
add_host $IP4 $HOST4
add_host $IP5 $HOST5
add_host $IP6 $HOST6
echo

# ==============================
# 刷新 DNS 缓存
# ==============================
echo "正在刷新 DNS 缓存..."
if [[ "$(uname)" == "Darwin" ]]; then
    # macOS
    dscacheutil -flushcache
    sudo killall -HUP mDNSResponder
else
    # Linux (systemd-resolved 或 nscd)
    if command -v systemctl &>/dev/null; then
        systemctl restart systemd-resolved
    elif command -v service &>/dev/null; then
        service nscd restart
    fi
fi
echo "DNS 刷新完成。"
echo

# # ==============================
# # 测试解析
# # ==============================
# TEST_DOMAIN="$HOST5"
# EXPECT_IP="$IP5"

# echo "正在测试域名解析：$TEST_DOMAIN ..."
# RESOLVE_IP=$(getent hosts $TEST_DOMAIN | awk '{print $1}')

# if [[ "$RESOLVE_IP" == "$EXPECT_IP" ]]; then
#     echo "成功：$TEST_DOMAIN 已正确解析为 $EXPECT_IP"
# else
#     echo "错误：域名解析与预期不一致！"
#     echo "期望 IP：$EXPECT_IP"
#     echo "实际 IP：$RESOLVE_IP"
# fi

# echo
echo "hosts 添加完成！\n 输出当前hosts 内容"

cat /etc/hosts